/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.fw.certs.CertUtils;
import com.ibm.hwmca.fw.upgrddat.UpgradeData;
import com.ibm.hwmca.fw.upgrddat.UpgradeDataException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class CertMgtUpgradeData
implements UpgradeData {
    private static final String TRACE_MASKT = "XCRTUPDT";
    private static final String TRACE_MASKF = "XCRTUPDF";
    private static final String TRACE_MASKD = "XCRTUPDD";
    private static final String DUMMY_ENTRY = "Dummy Entry";

    public CertMgtUpgradeData() throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "<-> CertMgtUpgradeData()");
    }

    public static void main(String[] args) {
        StringBuffer argsLine = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            argsLine.append(' ');
            argsLine.append(args[i]);
        }
        Trace.trace(TRACE_MASKD, "main() called with the following parameters :" + argsLine.toString());
    }

    public String getUpgradeDataVersion() throws UpgradeDataException {
        String result = "00001";
        Trace.trace(TRACE_MASKT, "-> getUpgradeDataVersion()");
        Trace.trace(TRACE_MASKT, "<- getUpgradeDataVersion() returning " + result + ".");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUpgradeData(OutputStream streamNameOut) throws UpgradeDataException {
        byte[] buf = null;
        ZipOutputStream zipOut = null;
        List filesToSave = null;
        String fileNameToSave = null;
        Object fullFileNameToSave = null;
        FileInputStream fileToSave = null;
        Object exception = null;
        boolean putEntry = false;
        String absoluteFileNameToSave = null;
        Trace.trace(TRACE_MASKT, "-> saveUpgradeData(" + streamNameOut + ")");
        try {
            streamNameOut.flush();
            zipOut = new ZipOutputStream(streamNameOut);
            Trace.trace(TRACE_MASKF, "Created ZIP output stream");
            zipOut.putNextEntry(new ZipEntry(DUMMY_ENTRY));
            zipOut.closeEntry();
            filesToSave = CertMgtUpgradeData.getConfigFileNames();
            buf = new byte[1024];
            Iterator i = filesToSave.iterator();
            while (i.hasNext()) {
                block11: {
                    Object var14_15;
                    try {
                        fileToSave = null;
                        putEntry = false;
                        fileNameToSave = (String)i.next();
                        absoluteFileNameToSave = CertUtils.getFQFileName(fileNameToSave);
                        try {
                            fileToSave = new FileInputStream(absoluteFileNameToSave);
                            Trace.trace(TRACE_MASKF, "Opened file " + absoluteFileNameToSave + ".");
                        }
                        catch (FileNotFoundException e) {
                            Trace.trace(TRACE_MASKF, "File not found : " + absoluteFileNameToSave);
                            var14_15 = null;
                            if (fileToSave != null) {
                                fileToSave.close();
                            }
                            if (!putEntry) continue;
                            zipOut.closeEntry();
                            continue;
                        }
                        zipOut.putNextEntry(new ZipEntry(fileNameToSave));
                        putEntry = true;
                        int len = 0;
                        while ((len = fileToSave.read(buf)) >= 0) {
                            if (len <= 0) continue;
                            zipOut.write(buf, 0, len);
                            Trace.trace(TRACE_MASKF, "Wrote " + len + " bytes.");
                        }
                        var14_15 = null;
                        if (fileToSave == null) break block11;
                    }
                    catch (Throwable throwable) {
                        var14_15 = null;
                        if (fileToSave != null) {
                            fileToSave.close();
                        }
                        if (putEntry) {
                            zipOut.closeEntry();
                        }
                        throw throwable;
                    }
                    fileToSave.close();
                }
                if (!putEntry) continue;
                zipOut.closeEntry();
                {
                }
            }
            zipOut.finish();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException occurred : " + e);
            throw new UpgradeDataException(e);
        }
        Trace.trace(TRACE_MASKT, "<- saveUpgradeData(...)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreUpgradeData(InputStream streamNameIn, String versionLevel) throws UpgradeDataException {
        Object zipIn = null;
        ZipEntry currentEntry = null;
        String currentEntryName = null;
        File currentFile = null;
        FileOutputStream fileOut = null;
        ZipInputStream zipInput = null;
        String currentAbsoluteFileName = null;
        Trace.trace(TRACE_MASKT, "-> restoreUpgradeData(" + streamNameIn + ", " + versionLevel + ")");
        try {
            zipInput = new ZipInputStream(streamNameIn);
            byte[] readBuffer = new byte[1024];
            while ((currentEntry = zipInput.getNextEntry()) != null) {
                currentEntryName = currentEntry.getName();
                if (currentEntryName.equals(DUMMY_ENTRY)) continue;
                currentAbsoluteFileName = CertUtils.getFQFileName(currentEntryName);
                Trace.trace(TRACE_MASKF, "Zip entry name is :" + currentEntryName);
                currentFile = new File(currentAbsoluteFileName);
                if (currentFile.exists()) {
                    currentFile.delete();
                    Trace.trace(TRACE_MASKF, "Deleted existing file " + currentAbsoluteFileName + ".");
                }
                try {
                    fileOut = null;
                    fileOut = new FileOutputStream(currentFile);
                    int bytesRead = 0;
                    while ((bytesRead = zipInput.read(readBuffer)) >= 0) {
                        if (bytesRead <= 0) continue;
                        fileOut.write(readBuffer, 0, bytesRead);
                        Trace.trace(TRACE_MASKF, "Wrote " + bytesRead + " bytes.");
                    }
                }
                finally {
                    if (fileOut != null) {
                        fileOut.close();
                    }
                }
                Trace.trace(TRACE_MASKF, "File size written is :" + currentEntry.getSize());
            }
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException occurred: " + e);
            throw new UpgradeDataException(e);
        }
        Trace.trace(TRACE_MASKT, "<- restoreUpgradeData(...");
    }

    private static List getConfigFileNames() {
        ArrayList<String> result = null;
        result = new ArrayList<String>();
        result.add("server.crt");
        result.add("signing_chain.crts");
        result.add("server.key");
        result.add("pending.server.key");
        result.add("hmc_ssl.conf");
        return result;
    }
}

